# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PrivateApplicationLogoArgs',
    'PrivateApplicationLogoArgsDict',
    'PrivateApplicationPackageDetailsArgs',
    'PrivateApplicationPackageDetailsArgsDict',
    'GetPrivateApplicationPackagesFilterArgs',
    'GetPrivateApplicationPackagesFilterArgsDict',
    'GetPrivateApplicationsFilterArgs',
    'GetPrivateApplicationsFilterArgsDict',
    'GetServiceCatalogAssociationsFilterArgs',
    'GetServiceCatalogAssociationsFilterArgsDict',
    'GetServiceCatalogsFilterArgs',
    'GetServiceCatalogsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class PrivateApplicationLogoArgsDict(TypedDict):
        content_url: NotRequired[pulumi.Input[str]]
        """
        The content URL of the uploaded data.
        """
        display_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The name of the private application.
        """
        mime_type: NotRequired[pulumi.Input[str]]
        """
        The MIME type of the uploaded data.
        """
elif False:
    PrivateApplicationLogoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrivateApplicationLogoArgs:
    def __init__(__self__, *,
                 content_url: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 mime_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content_url: The content URL of the uploaded data.
        :param pulumi.Input[str] display_name: (Updatable) The name of the private application.
        :param pulumi.Input[str] mime_type: The MIME type of the uploaded data.
        """
        if content_url is not None:
            pulumi.set(__self__, "content_url", content_url)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)

    @property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> Optional[pulumi.Input[str]]:
        """
        The content URL of the uploaded data.
        """
        return pulumi.get(self, "content_url")

    @content_url.setter
    def content_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_url", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the private application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[pulumi.Input[str]]:
        """
        The MIME type of the uploaded data.
        """
        return pulumi.get(self, "mime_type")

    @mime_type.setter
    def mime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mime_type", value)


if not MYPY:
    class PrivateApplicationPackageDetailsArgsDict(TypedDict):
        package_type: pulumi.Input[str]
        """
        The package's type.
        """
        version: pulumi.Input[str]
        """
        The package version.
        """
        zip_file_base64encoded: NotRequired[pulumi.Input[str]]
elif False:
    PrivateApplicationPackageDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrivateApplicationPackageDetailsArgs:
    def __init__(__self__, *,
                 package_type: pulumi.Input[str],
                 version: pulumi.Input[str],
                 zip_file_base64encoded: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] package_type: The package's type.
        :param pulumi.Input[str] version: The package version.
        """
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "version", version)
        if zip_file_base64encoded is not None:
            pulumi.set(__self__, "zip_file_base64encoded", zip_file_base64encoded)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Input[str]:
        """
        The package's type.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The package version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="zipFileBase64encoded")
    def zip_file_base64encoded(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "zip_file_base64encoded")

    @zip_file_base64encoded.setter
    def zip_file_base64encoded(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zip_file_base64encoded", value)


if not MYPY:
    class GetPrivateApplicationPackagesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetPrivateApplicationPackagesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPrivateApplicationPackagesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetPrivateApplicationsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetPrivateApplicationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPrivateApplicationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetServiceCatalogAssociationsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetServiceCatalogAssociationsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServiceCatalogAssociationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetServiceCatalogsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetServiceCatalogsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServiceCatalogsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


