#!/usr/bin/python
#
# Licensed to the Software Freedom Conservancy (SFC) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The SFC licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.


class AbstractEventListener(object):
    """
    Event listener must subclass and implement this fully or partially
    """
    
    def before_navigate_to(self, url, driver):  pass
        
    def after_navigate_to(self, url, driver):   pass
        
    def before_navigate_back(self, driver): pass
    
    def after_navigate_back(self, driver):  pass
    
    def before_navigate_forward(self, driver):  pass
    
    def after_navigate_forward(self, driver):   pass
    
    def before_find(self, by, value, driver):   pass
    
    def after_find(self, by, value, driver):    pass
    
    def before_click(self, element, driver):    pass
    
    def after_click(self, element, driver): pass
    
    def before_change_value_of(self, element, driver):  pass
    
    def after_change_value_of(self, element, driver):   pass
    
    def before_execute_script(self, script, driver):    pass
    
    def after_execute_script(self, script, driver): pass
    
    def before_close(self, driver): pass
    
    def after_close(self, driver):  pass
    
    def before_quit(self, driver):  pass
        
    def after_quit(self, driver):   pass
    
    def on_exception(self, exception, driver):  pass
